/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.InputBlock;

public class ShiftRegisterInputBlock
extends InputBlock {
    private static final long serialVersionUID = 3768756937956771461L;
    private transient Interpreter fInterpreter;

    public ShiftRegisterInputBlock() {
    }

    public ShiftRegisterInputBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
        this.fSimulationParameter = null;
    }

    public String getNumberPrefix() {
        return "S";
    }

    public int getNumberType() {
        return 19;
    }

    public SimulationParameter getSimulationParameter() {
        return null;
    }

    protected boolean calculateBinaryValue() {
        int shiftRegisterValue = 0;
        if (this.fInterpreter != null) {
            shiftRegisterValue = this.fInterpreter.getShiftRegisterValue()[(this.getNumber() - 1) / 8];
        }
        return (shiftRegisterValue & 1 << (this.getNumber() - 1) % 8) != 0;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fInterpreter = interpreter;
    }

    public String getNumberString(int blockNumber) {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getNumberPrefix());
        ret.append((blockNumber - 1) / 8 + 1);
        ret.append('.');
        ret.append((blockNumber - 1) % 8 + 1);
        return ret.toString();
    }

    public void setNumberString(String newNumber) throws IllegalArgumentException {
        try {
            if (newNumber.length() == 2) {
                this.changeNumber(Integer.parseInt(newNumber.substring(1, 2)));
            } else {
                int num = (Integer.parseInt(newNumber.substring(1, 2)) - 1) * 8;
                this.changeNumber(num += Integer.parseInt(newNumber.substring(3, 4)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
        this.fireBlockNameChangedEvent();
    }
}

